import java.net.*;
import java.io.*;
import java.util.Vector;

public class EchoServerConsole
{
  protected Vector<EchoServerCommThread> threadList;
  protected EchoServerNetThread esNetThread = null;
  protected BufferedReader brInput = null;
  public EchoServerConsole()
  {
    threadList = new Vector<EchoServerCommThread>();
    esNetThread = new EchoServerNetThread(this, 6666);
    esNetThread.start();
    try{
      brInput = new BufferedReader(
        new InputStreamReader(System.in));
    }
    catch(Exception e){
      log("Bd przy tworzeniu strumienia wejciowego: " + e);
      System.exit(-1);
    }
  }
  public static void main(String args[])
  {
    EchoServerConsole escon = new EchoServerConsole();
    escon.start();
  }
  public void start()
  {
    String line;
    while(true){
      try{
        System.out.print(">");
        line = brInput.readLine();
        if (line.equals("quit")){
          shutdown();
        }
        else if (line.equals("status")){
          showStatus();
        }
        else if (line.equals("help")){
          showHelp();
        }
        else{
          System.out.println(
            "Nieznane polecenie. Wpisz help, aby uzyska pomoc.");
        }
      }
      catch(IOException e){
        log("Bd wejcia-wyjcia: " + e);
        System.exit(-1);
      }
      catch(Exception e){
        log("Bd oglny: " + e);
        System.exit(-1);
      }
    }
  }
  public void addThread(EchoServerCommThread thread)
  {
    threadList.add(thread);
  }
  public void removeThread(EchoServerCommThread thread)
  {
    threadList.remove(thread);
  }
  public void log(String line)
  {
    //System.out.println(line);
  }
  public void shutdown()
  {
    System.out.println("Koczenie pracy...");
    esNetThread.interrupt();
    for(int i = 0; i < threadList.size(); i++){
      threadList.elementAt(i).interrupt();
    }
    try{
      Thread.sleep(200);
    }
    catch(Exception e){}
    System.exit(0);
  }  
  public void showStatus()
  {
    if (threadList.size() < 1){
      System.out.println("Nie ma adnych pocze.");
    }
    else{
      for(int i = 0; i < threadList.size(); i++){
        System.out.println(
          threadList.elementAt(i).getInfo());
      }
    }
  }
  public void showHelp(){
    System.out.println(
      "Rozpoznawane polecenia to: status help quit");
  }
}
